var page = require('webpage').create(),
    system = require('system'),
    address, output, w, h;

if (system.args.length < 3 || system.args.length > 5) {
    console.log('phantomjs: Invalid arguments');
    phantom.exit(36);
} else {
    address = system.args[1];
    output = system.args[2];
    w = 0;    
    if (system.args.length > 3) {
        w = system.args[3];
    }
    h = 0;
    if (system.args.length > 4) {
        h = system.args[4];
    }
    if (w > 0 && h > 0) {
    page.viewportSize = { width: w, height: h };
    }

    page.open(address, function (status) {
        if (status !== 'success') {
            console.log('phantomjs: Unable to load the address!');
            phantom.exit(12);
        } else {
            window.setTimeout(function () {
                page.render(output);
                phantom.exit();
            }, 200);
        }
    });
}
